#include common_scripts\utility;
#include maps\mp\_utility;
#include maps\mp\gametypes\_hud_util;

init()
{
	setDvar("scr_player_maxhealth", 10000);
	setDvarIfUninitialized("mef_scorelimit", 10);
	setDvarIfUninitialized("mef_blockhealth", 100);
	level.blockSpawn = [];
	level.blockEntity = [];
	level.blocks = 0;
	level.blockHealth = getDvarInt("mef_blockhealth");
	level.customFX = [];
	level.customFX["raygun_laser"]=				loadfx( "vfx/props/claymore_laser" );//Updated for HMW
	level.customFX["fire_smoke"]=				loadfx( "fx/fire/fire_smoke_trail_l");//Updated for HMW
	level.customFX["fire_ball"]=				loadfx( "vfx/trail/trail_fire_smoke_l");//Updated for HMW
	level.customFX["large_vehicle_explosion"]=	loadfx( "explosions/large_vehicle_explosion");//Updated for HMW
	level.customFX["force_field"]=				loadfx( "fx/fire/jet_afterburner_harrier" );//Updated for HMW
	level.customFX["red_blink_light"]=			loadfx( "vfx/lights/light_c4_blink");//Updated for HMW
	level.customFX["mine_flash"]=				loadfx( "vfx/explosion/frag_grenade_flash" );//Updated for HMW
	level.customFX["mine_explosion"]=			loadfx( "fx/explosions/artilleryexp_dirt_brown_2");//Updated for HMW
	level.spawnedPlayers = 0;
	level.gameState = "beginning";
	level thread onPlayerConnect();
}
checkPoints()
{
	while(1){
		foreach(player in level.players)
		{
			if(player.mef_points >= getDvarInt("mef_scorelimit"))
			{
				level thread maps\mp\gametypes\_gamelogic::endGame( player.team, player.name + " is the the winner!" );
				level notify("game_end");
			}
		}
		wait 1;
	}
}


pointSystem()
{
	offset = 35;
	self.point_text = self createFontString("default", 1.4);
	self.point_text setPos("left_adjustable", "top_adjustable", "left", "middle", 160-offset, 25);
	self.point_text.hideWhenInMenu = true;
	self.point_text.archived = false;
	self.point_text.glowAlpha = 0.5;
	self.point_text.glowColor = (0,0,0);
	self.score_text = self createFontString("default", 1.4);
	self.score_text setPos("left_adjustable", "top_adjustable", "left", "middle", 270-offset, 25);
	self.score_text.hideWhenInMenu = true;
	self.score_text.archived = false;
	self.score_text.glowAlpha = 0.5;
	self.score_text.glowColor = (1,0,0);
	self.score_text setValue( self.mef_points );
	self.point_text setText( "Your Points:" );
}

setPos( horz, vert, ax, ay, x, y )
{
	self.horzAlign = horz;
	self.vertAlign = vert;
	self.alignX = ax;
	self.alignY = ay;
	self.x = x;
	self.y = y;
}

onPlayerConnect()
{
	for(;;)
	{
		level waittill( "connected", player );
		player.mef_points = 0;
		if(!level.setupGame){
			level.setupGame = true;
			level thread checkPoints();
			level thread assignRandomWeapons();
			level thread monitorLastPlayer();
			level thread monitorDeathHeight();
			level thread grenadeChance();
			level thread user_scripts\mp_patches\mef\edits::init();
			setslowmotion( 0.025, 1, 0.025 );//fixes stuttering after map restart during killcam/nuke slowmotion.
		}
		//if(level.gameState != "playing")
			player.hasDied = false;
		//else
		//	player.hasDied = true;
		player thread onPlayerSpawned();
		player thread updatePoints();
		//player thread pointSystem();
	}
}

monitorDeathHeight(){
	while(1){
		foreach(player in level.players){
			if(player.origin[2] < level.blockSpawn[0][2]-300 && player isOnGround())
				player _suicide();
		}
		wait 1;
	}
}

updatePoints(){
	self endon("disconnect");
	while(1){
		//self.score_text setValue( self.mef_points );
		if(self.score != self.mef_points){
			self.score = self.mef_points;
		}
		//if(self.extrascore0 != self.mef_points){
		//	self.extrascore0 = self.mef_points;
		//}
		wait 0.1;
	}
}

onPlayerSpawned()
{
	for(;;)
	{
		self endon("disconnect");
		self waittill("spawned_player");

		level.spawnedPlayers++;

		self allowspectateteam( "allies", 1 );
		self allowspectateteam( "axis", 1 );
		self allowspectateteam( "none", 1 );
		self allowspectateteam( "freelook", 1 );

		self thread setupPlayer();
		self thread watchLives();
		self thread watchWeapons();
	}
}

watchWeapons(){
	self endon("death");
	self endon("disconnect");
	while(1){
		//isSubStr( self getCurrentWeapon(), level.loudout["weapons"]["primary"] )
		if(self getCurrentWeapon() != level.loudout["weapons"]["primary"] && self getCurrentWeapon() != level.loudout["weapons"]["secondary"] && !self.hasDied && level.gameState != "intermition"){
			self takeAllWeapons();
			self _clearPerks();
			self thread giveRandomWeapon();
			self thread giveGrenade();
		}
		//self iPrintLn(self.extrascore0);
		wait 0.5;
	}
}

monitorLastPlayer(){
	for(;;){
		total = level.players.size;
		foreach(player in level.players){
			if(player.hasDied){
				total--;
			}
		}
		if(level.players.size == 1 && player.hasDied){
			level notify("round_reset");
			level user_scripts\mp_patches\mef\edits::init();
			player.hasDied = false;
			player thread setupPlayer();
		}
		if(total <= 1 && level.players.size > 1){
			level.gameState = "intermition";
			foreach(player in level.players){
				if(!player.hasDied){
					player takeAllWeapons();
					player _clearPerks();
					player thread ufoSpectate();
					player.mef_points++;
				}
					
			}
			level thread pickRandomWeapons();
			level notify("round_reset");
			iPrintLnBold("^1Round Over!");
			while(level.spawnedPlayers < level.players.size){
				//iPrintLn("level.players.size: "+level.players.size);
				//iPrintLn("level.spawnedPlayers: "+level.spawnedPlayers);
				wait 0.025;
			}
				
			level user_scripts\mp_patches\mef\edits::init();
			iPrintLnBold("^3Next round starts now!");
			level grenadeChance();
			foreach(player in level.players){
				player.hasDied = false;
				player thread setupPlayer();
			}
			level.gameState = "playing";
		}
		wait 0.1;
	}
}

watchLives(){
	self waittill_any("death", "disconnect");
	self.hasDied = true;
	level.spawnedPlayers--;
}

ufoSpectate(var_0){
	if(var_0){
		self setSpawns();
		if(!isDefined(self.ufoSpectate))
			self.ufoSpectate = spawn("script_origin", self.origin);
		self playerlinkto(self.ufoSpectate);
		self hide();
		self.oldDeaths = self.deaths;
		self.deaths = 0;
		self.isSpecating = true;
		self _giveWeapon("h2_usp_mp");
		self setWeaponAmmoClip( "h2_usp_mp", 0, "left" );
		self setWeaponAmmoClip( "h2_usp_mp", 0, "right" );
		self setWeaponAmmoStock( "h2_usp_mp", 0);
		wait 0.1;
		self switchToWeapon("h2_usp_mp");
	}
	else{
		self unlink();
		self show();
		self.deaths = self.oldDeaths;
		self.isSpecating = false;
	}
}

setupPlayer(){
	self takeAllWeapons();
	self _clearPerks();
	self freezeControls(true);
	self setSpawns();
	while(level.buildingMap){
		self freezeControls(true); 
		wait 0.025;
	}
	if(self.hasDied){
		self thread ufoSpectate(true);
		return;
	}
	else{
		self thread ufoSpectate(false);
	}
		
		
	self freezeControls(false);
	self VisionSetNakedForPlayer(getDvar("mapname"), 0);
	self thread giveRandomWeapon();
	self thread UnlimitedAmmo();
	self thread giveGrenade();
	maps\mp\_utility::giveperk("specialty_extendedmelee", 0 );
	maps\mp\_utility::giveperk("specialty_bulletaccuracy", 0 );
	maps\mp\_utility::giveperk("specialty_lightweight", 0 );
	maps\mp\_utility::giveperk("specialty_fastsprintrecovery", 0 );
	maps\mp\_utility::givePerk("specialty_longersprint", 0 );
}

grenadeChance(){
	level.giveGrenade = false;
	switch(randomint(3)){
		case 0:
			level.giveGrenade = true;
		break;
		case 1:
			level.giveGrenade = true;
		break;
		case 2:
			level.giveGrenade = true;
		break;
	}
}

watchGrenade(){
	self notify("grenadeLoop");
	self endon("grenadeLoop");
	self endon("death");
	self endon("disconnect");
	self waittill("grenade_fire", grenade, weaponName);
	if(weaponName == "h2_semtex_mp"){
		grenade waittill("missile_stuck");
		foreach(block in level.blockEntity){
			if(distance(block.origin, grenade.origin) < 110){
				block thread waitToDelete(self);
			}
		}
		grenade waittill( "activated" );
		self notify("grenade_explode");
	}
}

waitToDelete(owner){
	owner waittill("grenade_explode");
	self delete();
}

giveGrenade(){
	if(level.giveGrenade){
		self thread watchGrenade();
		self setlethalweapon( "h2_semtex_mp" );
		self maps\mp\gametypes\_class::giveoffhand("h2_semtex_mp");
		self setWeaponAmmoClip("h2_semtex_mp", 1);
	}
}

giveRandomWeapon()
{
	self _giveWeapon(level.loudout["weapons"]["secondary"]);
	wait 0.1;
	self switchToWeapon(level.loudout["weapons"]["secondary"]);
}

UnlimitedAmmo()
{
	self notify ( "ammoLoop" );
	self endon ( "ammoLoop" );
	self endon ( "death" );
	self endon ( "disconnect" );
	while ( 1 )
	{
		currentweapon = self GetCurrentWeapon();
		if(self.isSpecating){
			self setWeaponAmmoClip( currentweapon, 0 );
			self setWeaponAmmoClip( currentweapon, 0, "left" );
			self setWeaponAmmoClip( currentweapon, 0, "right" );
		}
		else{
			self setWeaponAmmoClip( currentweapon, 9999 );
			self setWeaponAmmoClip( currentweapon, 9999, "left" );
			self setWeaponAmmoClip( currentweapon, 9999, "right" );
		}
		wait 0.025;
	}
}

pickRandomWeapons()
{
	pWeapon = "";
	switch(randomint(7)){
		case 0:
			pWeapon = getRandomAttachments(level.weapon_secondary_shotguns[randomint(level.weapon_secondary_shotguns.size)]);
		break;
		case 1:
			pWeapon = getRandomAttachments(level.weapon_snipers[randomint(level.weapon_snipers.size)]);
		break;
		case 2:
			pWeapon = getRandomAttachments(level.weapon_heavys[randomint(level.weapon_heavys.size)]);
		break;
		case 3:
			pWeapon = getRandomAttachments(level.weapon_smgs[randomint(level.weapon_smgs.size)]);
		break;
		case 4:
			pWeapon = getRandomAttachments(level.weapon_assaults[randomint(level.weapon_assaults.size)]);
		break;
		case 5:
			pWeapon = getRandomAttachments(level.weapon_secondary_machine_pistols[randomint(level.weapon_secondary_machine_pistols.size)]);
		break;
		case 6:
			pWeapon = getRandomAttachments(level.weapon_pistols[randomint(level.weapon_pistols.size)]);
		break;
	}
	//iPrintLn("pWeapon: "+pWeapon);
	level.loudout["weapons"]["primary"] = pWeapon;

	sWeapon = "";
	switch(randomint(3)){
		case 0:
			sWeapon = getRandomAttachments(level.weapon_secondary_machine_pistols[randomint(level.weapon_secondary_machine_pistols.size)]);
		break;
		case 1:
			sWeapon = getRandomAttachments(level.weapon_pistols[randomint(level.weapon_pistols.size)]);
		break;
		case 2:
			sWeapon = getRandomAttachments(level.weapon_secondary_shotguns[randomint(level.weapon_secondary_shotguns.size)]);
		break;
	}
	level.loudout["weapons"]["secondary"] = sWeapon;
	level.loudout["weapons"]["primary"] = getWeaponFullName(level.loudout["weapons"]["primary"], randomint(46));
	level.loudout["weapons"]["secondary"] = getWeaponFullName(level.loudout["weapons"]["secondary"], randomint(46));
}

setSpawns(){
	self notify("spawnLoop");
	self endon("spawnLoop");
	while(level.buildingMap)
		wait 0.025;

	self SetOrigin(level.blockSpawn[randomInt(level.blocks)]+(0,0,150));
	/*self.spawnPointSet = false;
	while(!self.spawnPointSet){
		var_0 = randomInt(level.blocks);
		if(isDefined(level.blockSpawn[var_0].origin)){
			self.spawnPoint = level.blockSpawn[var_0].origin;
			self.spawnPointSet = true;
		}
	}
	self SetOrigin(self.spawnPoint+(0,0,150));*/
	/*
	self.randomspawn = randomInt(12);
	if(self.randomspawn == 0)
	{
		self SetOrigin((2350,-1064,1100));
	}
	if(self.randomspawn == 1)
	{
		self SetOrigin((2360,-1064,1100));
	}
	if(self.randomspawn == 2)
	{
		self SetOrigin((2370,-1064,1100));
	}
	if(self.randomspawn == 3)
	{
		self SetOrigin((2380,-1064,1100));
	}
	if(self.randomspawn == 4)
	{
		self SetOrigin((2390,-1064,1100));
	}
	if(self.randomspawn == 5)
	{
		self SetOrigin((2400,-1064,1100));
	}
	if(self.randomspawn == 6)
	{
		self SetOrigin((2350,-1054,1100));
	}
	if(self.randomspawn == 7)
	{
		self SetOrigin((2360,-1044,1100));
	}
	if(self.randomspawn == 8)
	{
		self SetOrigin((2370,-1034,1100));
	}
	if(self.randomspawn == 9)
	{
		self SetOrigin((2380,-1024,1100));
	}
	if(self.randomspawn == 10)
	{
		self SetOrigin((2390,-1014,1100));
	}
	if(self.randomspawn == 11)
	{
		self SetOrigin((2400,-1004,1100));
	}*/
}

assignRandomWeapons(){
	level.loudout = [];
	level.weapon_secondary_shotguns = [];
	level.weapon_snipers = [];
	level.weapon_bolts = [];
	level.weapon_heavys = [];
	level.weapon_smgs = [];
	level.weapon_assaults = [];
	level.weapon_secondary_machine_pistols = [];
	level.weapon_pistols = [];
	foreach(weapon in level.weaponList){
		switch(maps\mp\_utility::getweaponclass(weapon)){
			case "weapon_secondary_shotgun":
				level.weapon_secondary_shotguns[level.weapon_secondary_shotguns.size] = weapon;
				level.weapon_secondary_shotguns++;
			break;
			case "weapon_sniper":
				if(isBoltAction(weapon)){
					level.weapon_bolts[level.weapon_bolts.size] = weapon;
					level.weapon_bolts++;
				}
				level.weapon_snipers[level.weapon_snipers.size] = weapon;
				level.weapon_snipers++;
			break;
			case "weapon_heavy":
				level.weapon_heavys[level.weapon_heavys.size] = weapon;
				level.weapon_heavys++;
			break;
			case "weapon_smg":
				level.weapon_smgs[level.weapon_smgs.size] = weapon;
				level.weapon_smgs++;
			break;
			case "weapon_assault":
				level.weapon_assaults[level.weapon_assaults.size] = weapon;
				level.weapon_assaults++;
			break;
			case "weapon_secondary_machine_pistol":
				level.weapon_secondary_machine_pistols[level.weapon_secondary_machine_pistols.size] = weapon;
				level.weapon_secondary_machine_pistols++;
			break;
			case "weapon_pistol":
				level.weapon_pistols[level.weapon_pistols.size] = weapon;
				level.weapon_pistols++;
			break;
		}
	}
	level thread pickRandomWeapons();
}

getWeaponFullName(weapon, camo){
    if(camo == 0 || weapon == "none" || weapon == "")
        return weapon;
    else if(camo > 0 && camo < 10)
        return weapon+"_camo00"+camo;
    else if(camo >= 10 && camo < 100)
        return weapon+"_camo0"+camo;
    else if(camo >= 100)
        return weapon+"_camo"+camo;
}

getRandomAttachments(weapon){
	var_0 = "";
	var_1 = "";
	switch(maps\mp\_utility::getweaponclass(weapon)){
		case "weapon_secondary_shotgun":
		if(
			weapon == "h2_spas12_mp" ||
			weapon == "h2_aa12_mp" ||
			weapon == "h2_striker_mp" ||
			weapon == "h2_m1014_mp" ||
			weapon == "h2_winchester1200_mp"
		){
			switch(randomint(12)){
				case 0:
					var_0 = "foregrip";
				break;
				case 1:
					var_0 = "reflex";
				break;
				case 2:
					var_0 = "silencershotgun";
				break;
				case 3:
					var_0 = "holo_silencershotgun";
				break;
				case 4:
					var_0 = "reflex_silencershotgun";
				break;
				case 5:
					var_0 = "reflex_xmag";
				break;
				case 6:
					var_0 = "fmj";
				break;
				case 7:
					var_0 = "fmj_xmag";
				break;
				case 8:
					var_0 = "fmj_reflex";
				break;
				case 9:
					var_0 = "fmj_holo";
				break;
				case 10:
					var_0 = "holo";
				break;
				case 11:
					var_0 = "xmag";
				break;
			}
		}
		else if(
			weapon == "h2_model1887_mp" ||
			weapon == "h2_ranger_mp"
		){
			switch(randomint(5)){
				case 0:
					var_0 = "fmj";
				break;
				case 1:
					var_0 = "xmag";
				break;
				case 2:
					var_0 = "akimbo";
				break;
				case 3:
					var_0 = "akimbo_fmj";
				break;
				case 4:
					var_0 = "akimbo_xmag";
				break;
			}
		}
		break;
		case "weapon_sniper":
			
			switch(randomint(4)){
				case 0:
					var_0 = "fmj";
				break;
				case 1:
					var_0 = "silencersniper";
				break;
				case 2:
					var_0 = "xmag";
				break;
				case 3:
					var_0 = "silencersniper_xmag";
				break;
			}

		break;
		case "weapon_heavy":

		switch(randomint(13)){
				case 0:
					var_0 = "reflex";
				break;
				case 1:
					var_0 = "fmj";
				break;
				case 2:
					var_0 = "silencerlmg";
				break;
				case 3:
					var_0 = "holo";
				break;
				case 4:
					var_0 = "xmag";
				break;
				case 5:
					var_0 = "silencerlmg_xmag";
				break;
				case 6:
					var_0 = "reflex_xmag";
				break;
				case 7:
					var_0 = "fmj_reflex";
				break;
				case 8:
					var_0 = "fmj_holo";
				break;
				case 9:
					var_0 = "holo_xmag";
				break;
				case 10:
					var_0 = "holo_silencerlmg";
				break;
				case 11:
					var_0 = "reflex_silencerlmg";
				break;
				case 12:
					var_0 = "foregrip";
				break;
			}
			
		break;
		case "weapon_smg":
		
		if(weapon == "h2_ak74u_mp"){
			switch(randomint(17)){
				case 0:
					var_0 = "holo";
				break;
				case 1:
					var_0 = "reflex";
				break;
				case 2:
					var_0 = "silencersmg";
				break;
				case 3:
					var_0 = "fmj";
				break;
				case 4:
					var_0 = "xmag";
				break;
				case 5:
					var_0 = "acog";
				break;
				case 6:
					var_0 = "holo_xmag";
				break;
				case 7:
					var_0 = "holo_silencersmg";
				break;
				case 8:
					var_0 = "fmj_xmag";
				break;
				case 9:
					var_0 = "reflex_silencersmg";
				break;
				case 10:
					var_0 = "fmj_reflex";
				break;
				case 11:
					var_0 = "reflex_xmag";
				break;
				case 12:
					var_0 = "acog_silencersmg";
				break;
				case 13:
					var_0 = "acog_fmj";
				break;
				case 14:
					var_0 = "acog_xmag";
				break;
				case 15:
					var_0 = "fmj_holo";
				break;
				case 16:
					var_0 = "silencersmg_xmag";
				break;
			}
		}
		else{
			switch(randomint(16)){
				case 0:
					var_0 = "reflex";
				break;
				case 1:
					var_0 = "fmj";
				break;
				case 2:
					var_0 = "silencersmg";
				break;
				case 3:
					var_0 = "holo";
				break;
				case 4:
					var_0 = "xmag";
				break;
				case 5:
					var_0 = "silencersmg_xmag";
				break;
				case 6:
					var_0 = "reflex_xmag";
				break;
				case 7:
					var_0 = "fmj_reflex";
				break;
				case 8:
					var_0 = "fmj_holo";
				break;
				case 9:
					var_0 = "holo_xmag";
				break;
				case 10:
					var_0 = "holo_silencersmg";
				break;
				case 11:
					var_0 = "reflex_silencersmg";
				break;
				case 12:
					var_0 = "akimbo";
				break;
				case 13:
					var_0 = "akimbo_xmag";
				break;
				case 14:
					var_0 = "akimbo_fmj";
				break;
				case 15:
					var_0 = "akimbo_silencersmg";
				break;
			}
		}
		break;
		case "weapon_assault":
			switch(randomint(17)){
				case 0:
					var_0 = "holo";
				break;
				case 1:
					var_0 = "reflex";
				break;
				case 2:
					var_0 = "silencerar";
				break;
				case 3:
					var_0 = "fmj";
				break;
				case 4:
					var_0 = "xmag";
				break;
				case 5:
					var_0 = "acog";
				break;
				case 6:
					var_0 = "holo_xmag";
				break;
				case 7:
					var_0 = "holo_silencerar";
				break;
				case 8:
					var_0 = "fmj_xmag";
				break;
				case 9:
					var_0 = "reflex_silencerar";
				break;
				case 10:
					var_0 = "fmj_reflex";
				break;
				case 11:
					var_0 = "reflex_xmag";
				break;
				case 12:
					var_0 = "acog_silencerar";
				break;
				case 13:
					var_0 = "acog_fmj";
				break;
				case 14:
					var_0 = "acog_xmag";
				break;
				case 15:
					var_0 = "fmj_holo";
				break;
				case 16:
					var_0 = "silencerar_xmag";
				break;
			}
		break;
		case "weapon_secondary_machine_pistol":
			var_99 = 12;
			if(canDoAkimbo(weapon))
				var_99 = 16;
			else
				var_99 = 12;
			switch(randomint(var_99)){
				case 0:
					var_0 = "reflex";
				break;
				case 1:
					var_0 = "fmj";
				break;
				case 2:
					var_0 = "silencerpistol";
				break;
				case 3:
					var_0 = "holo";
				break;
				case 4:
					var_0 = "xmag";
				break;
				case 5:
					var_0 = "silencerpistol_xmag";
				break;
				case 6:
					var_0 = "reflex_xmag";
				break;
				case 7:
					var_0 = "fmj_reflex";
				break;
				case 8:
					var_0 = "fmj_holo";
				break;
				case 9:
					var_0 = "holo_xmag";
				break;
				case 10:
					var_0 = "holo_silencerpistol";
				break;
				case 11:
					var_0 = "reflex_silencerpistol";
				break;
				case 12:
					var_0 = "akimbo";
				break;
				case 13:
					var_0 = "akimbo_xmag";
				break;
				case 14:
					var_0 = "akimbo_fmj";
				break;
				case 15:
					var_0 = "akimbo_silencerpistol";
				break;
			}
		break;
		case "weapon_pistol":
			var_99 = 8;
			if(canDoSilencer(weapon))
				var_99 = 9;
			else
				var_99 = 6;
			switch(randomint(var_99)){
				case 0:
					var_0 = "fmj";
				break;
				case 1:
					if(isSubStr( weapon, "h2_usp_mp" ))
						var_0 = "tacknifeusp";
					else if(isSubStr( weapon, "h2_deserteagle_mp" ))
						var_0 = "tacknifedeagle";
					else if(isSubStr( weapon, "h2_colt45_mp" ))
						var_0 = "tacknifecolt45";
					else if(isSubStr( weapon, "h2_m9_mp" ))
						var_0 = "tacknifem9";
				break;
				case 2:
					var_0 = "xmag";
				break;
				case 3:
					var_0 = "akimbo";
				break;
				case 4:
					var_0 = "akimbo_xmag";
				break;
				case 5:
					var_0 = "akimbo_fmj";
				break;
				case 6:
					var_0 = "silencerpistol";
				break;
				case 7:
					var_0 = "silencerpistol_xmag";
				break;
				case 8:
					var_0 = "akimbo_silencerpistol";
				break;
			}
		break;
	}
	if(var_0 != "")
		return weapon+"_"+var_0;
	else
		return weapon;
}

isBoltAction(weapon){
	if(
	weapon == "h2_cheytac_mp" ||
	weapon == "h2_m40a3_mp"
	)
		return true;
	else
		return false;
}

canDoAkimbo(weapon){
	if(
		weapon == "h2_glock_mp" ||
		weapon == "h2_beretta393_mp" ||
		weapon == "h2_tmp_mp"
	)
		return true;
	else
		return false;
}

canDoSilencer(weapon){
	if(
		weapon == "h2_coltanaconda_mp"
	)
		return false;
	else
		return true;
}

doBots(numberOfTestClients)
{
	for(i = 0; i < numberOfTestClients; i++)
	{
	ent[i] = addtestclient();
	if (!isdefined(ent[i]))
		{
			wait 1;
			continue;
		}
	ent[i].pers["isBot"] = true;
	ent[i] thread TestClient(i);
	wait 0.2;
	}
}

TestClient(i)
{
	self endon( "disconnect" );
	while(!isdefined(self.pers["team"]))
	{
	wait .05;
	self notify("menuresponse", game["menu_team"], "autoassign");
	wait 0.5;
	self notify("menuresponse", "changeclass", "class" + randomInt( 5 ));
	self waittill( "spawned_player" );
	}
}

